jQuery(window).on('elementor:init', function () {
  "use strict";
  
  var closeButton = jQuery('.eicon-close');
  closeButton.on('click', function () {
    jQuery('.widgetarea_iframe_modal').css('display', 'none')
  })

  var ControlBaseDataView = elementor.modules.controls.BaseData;
  var ControlWidgetAreaItemView = ControlBaseDataView.extend({
    ui: function ui() {
      var ui = ControlBaseDataView.prototype.ui.apply(this, arguments);
      ui.inputs = '[type="text"]';
      return ui;
    },

    events: function events() {
      return _.extend(ControlBaseDataView.prototype.events.apply(this, arguments), {
        'change @ui.inputs': 'onBaseInputChange'
      });
    },

    onBaseInputChange: function onBaseInputChange(event) {
      clearTimeout(this.correctionTimeout);
  
      var input = event.currentTarget,
          value = this.getInputValue(input),
          validators = this.validators.slice(0),
          settingsValidators = this.elementSettingsModel.validators[this.model.get('name')];
 
          //console.log(event.currentTarget);
          //console.log(value);

      this.updateElementModel(value, input);
  
      //this.triggerMethod('input:change', event);
    },

    onRender: function onRender() {
      ControlBaseDataView.prototype.onRender.apply(this, arguments);
      var self = this;

      setInterval(function(){ 
        var widgetarea_load = $('body').attr('data-elementskit-widgetarea-load'),
            widgetarea_key = $('body').attr('data-elementskit-widgetarea-key');

        // console.log([widgetarea_load, widgetarea_key]);

        if(widgetarea_load == 'true'){
          var time = new Date().getTime(),
          new_val,
          widgetarea_key_spilt = widgetarea_key.split('***');

          widgetarea_key_spilt = widgetarea_key_spilt[0];
          new_val = widgetarea_key_spilt + '***' + time;

          // console.log(new_val);

          $('body').attr('data-elementskit-widgetarea-load', 'false');
          self.setValue(new_val);
        }
      }, 2000);
    }
  }, {
    
    });
  elementor.addControlView('widgetarea', ControlWidgetAreaItemView);
});
