<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Instive_Video_Popup_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'instive-video-popup';
    }

    public function get_title() {

        return esc_html__( 'Video Popup', 'instive' );

    }

    public function get_icon() { 
        return 'eicon-youtube';
    }

    public function get_categories() {
        return [ 'instive-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Popup settings', 'instive'),
            ]
        );
        $this->add_control('icon_animation',
            [
            'label'       => esc_html__('Icon animation', 'instive'),
            'type'        => Controls_Manager::SWITCHER,
            'label_on'    => esc_html__('Yes', 'instive'),
            'label_off'   => esc_html__('No', 'instive'),
            'default'     => 'no',

            ]
      );   

        $this->add_control(
			'video_icon',
			[
				'label' => __( 'Social Icons', 'instive' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'default' => 'icon icon-play',
			]
		);


        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('Link', 'instive'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'label' => esc_html__( 'Typography', 'instive' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_2,
				'selector' => '{{WRAPPER}} .ts-play-btn',
			]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('icon color', 'instive'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-play-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_text_align', [
                'label'             =>esc_html__( 'Alignment', 'instive' ),
                'type'             => Controls_Manager::CHOOSE,
                'options'         => [
    
                    'left'         => [
                        'title'     =>esc_html__( 'Left', 'instive' ),
                        'icon'     => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title'     =>esc_html__( 'Center', 'instive' ),
                        'icon'     => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'     =>esc_html__( 'Right', 'instive' ),
                        'icon'     => 'fa fa-align-right',
                    ],
                ],
                'default'         => '',
               'selectors' => [
                   '{{WRAPPER}} .video-icon' => 'text-align: {{VALUE}};'
               ],
            ]
        );
      //   animation
        $this->add_control(
			'animation_icon_style',
			[
				'label' => __( 'Animation icon style', 'instive' ),
				'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => ["icon_animation" => ['yes']],

			]
      );
     
   
      $this->add_responsive_control(
         'anim_width',
         [
            'label' =>esc_html__( 'Icon Width', 'instive' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => ["icon_animation" => ['yes']],

            'range' => [
               'px' => [
                  'min' => 0,
                  'max' => 200,
               ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'tablet_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'mobile_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'selectors' => [
               '{{WRAPPER}} .ts-play-btn.video-btn' => 'width: {{SIZE}}{{UNIT}};',
            ],
         ]
      );
      $this->add_responsive_control(
         'anim_height',
         [
            'label' =>esc_html__( 'Icon Height', 'instive' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => ["icon_animation" => ['yes']],

            'range' => [
               'px' => [
                  'min' => 0,
                  'max' => 200,
               ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'tablet_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'mobile_default' => [
               'size' => 100,
               'unit' => 'px',
            ],
            'selectors' => [
               '{{WRAPPER}} .ts-play-btn.video-btn' => 'height: {{SIZE}}{{UNIT}};',
            ],
         ]
      );
      $this->add_responsive_control(
         'anim_icon_padding',
         [
            'label' => esc_html__( 'padding', 'instive' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'condition' => ["icon_animation" => ['yes']],

            'selectors' => [
               '{{WRAPPER}} .ts-play-btn.video-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
      );

      $this->add_control(
			'anim_before_border',
			[
				'label' => __( 'Before border', 'instive' ),
				'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => ["icon_animation" => ['yes']],

			]
      );
      $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'Before_border',
				'label' => __( 'Before Border', 'instive' ),
            'selector' => '{{WRAPPER}} .video-btn:after',
            'separator' => 'before',
            'condition' => ["icon_animation" => ['yes']],
			]
      );
      $this->add_control(
			'anim_after_border',
			[
				'label' => __( 'After border', 'instive' ),
				'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => ["icon_animation" => ['yes']],

			]
      );
      $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'after_border',
				'label' => __( 'After Border', 'instive' ),
            'selector' => '{{WRAPPER}} .video-btn .btn-hover-anim',
            'separator' => 'before',
            'condition' => ["icon_animation" => ['yes']],
			]
		);

        $this->end_controls_section();


     
    }

    protected function render( ) { 
        $settings = $this->get_settings();

        $video_icon = $settings['video_icon'];
        $icon_animation = $settings['icon_animation'];

    ?>
        <div class="video-icon">
            <a href="<?php echo esc_url($settings['video_url']['url']); ?>" class="ts-play-btn <?php echo esc_attr(($icon_animation == 'yes') ? 'video-btn' : ''); ?>">
                <i class="<?php echo  esc_attr($video_icon); ?>"></i>
                <span class="btn-hover-anim"></span>
            </a>
        </div>

    <?php  
    }
    protected function _content_template() { }
}