<?php 
$banner_image    = '';
$banner_title    = '';
$banner_style    = 'full';
$header_style    = 'standard';

if ( defined( 'FW' ) ) { 

    $page_sub_menu            = instive_meta_option( get_the_ID(), 'sub_header_menu' );
    $banner_settings          = instive_option('page_banner_setting'); 
    $banner_image             = instive_meta_option( get_the_ID(), 'header_image' );
    $header_style             = instive_option('header_layout_style', 'standard');

    //title
    if(instive_meta_option( get_the_ID(), 'header_title' ) != ''){
        $banner_title = instive_meta_option( get_the_ID(), 'header_title' );
     }elseif($banner_settings['banner_page_title'] != ''){
        $banner_title = $banner_settings['banner_page_title'];
    }else{
      $banner_title   = get_the_title();
    }
    
    //image
    if(is_array($banner_image) && $banner_image['url'] != '' ){
        $banner_image = $banner_image['url'];
    }elseif( is_array($banner_settings['banner_page_image']) && $banner_settings['banner_page_image']['url'] != ''){
          $banner_image = $banner_settings['banner_page_image']['url'];
    }else{
      
         $banner_image = INSTIVE_IMG.'/banner/banner_bg.jpg';
    }
     
   $show = (isset($banner_settings['page_show_banner'])) ? $banner_settings['page_show_banner'] : 'yes'; 
   // breadcumb
   $show_breadcrumb =  (isset($banner_settings['page_show_breadcrumb'])) ? $banner_settings['page_show_breadcrumb'] : 'yes';

 
 }else{
     //default
    $page_sub_menu             = '';
     $banner_image             = '';
     $banner_title             = get_the_title();
     $show                     = 'yes';
     $show_breadcrumb          = 'no';

 }
 if( $banner_image != ''){
    $banner_image = 'style="background-image:url('.esc_url( $banner_image ).');"';
 }
 $banner_heading_class = '';
if($header_style=="transparent"):
   $banner_heading_class     = "mt-80";   


endif;  

?>

<?php if(isset($show) && $show == 'yes'): ?>

    <section class="xs-breadcrumb breadcrumb-height">
        <div class="breadcrumb-bg banner-area <?php echo esc_attr($banner_image == ''?'banner-solid':'banner-bg'); ?>" <?php echo wp_kses_post( $banner_image ); ?>>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                     <div class="banner-heading text-center">
                        <h2>
                        <?php
                              if(is_archive()){
                                    the_archive_title();
                              }else {
                                  echo esc_html($banner_title);
                              }
                         ?>
                        </h2>

                    <?php if(isset($show_breadcrumb) && $show_breadcrumb == 'yes'): ?>
                    <?php instive_get_breadcrumbs(" "); ?>
                    <?php endif; ?>
                </div>

                </div>
            </div>
        </div>
        </div>
    </section>
  
<?php endif;

